/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.settings.network;

import com.ibm.hwmca.base.settings.SettingsConstants;
import com.ibm.hwmca.base.settings.SettingsErrorIds;
import com.ibm.hwmca.base.settings.network.DetailsFrameBean;
import com.ibm.hwmca.base.settings.network.IPAddressBean;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.config.DHCPServerRangeConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkSettingsConfig;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IP_P_AddressBean
extends IPAddressBean
implements SettingsConstants,
SettingsErrorIds {
    private String[] m_sPublicPrivateSettingSelection;
    private boolean m_bPartitionCommunication;
    private boolean m_bDHCPServerEnabled;
    private String m_sDHCPServerAddrRange;
    private ValueDescriptor[] m_cdDHCPServerAddrRange;
    private boolean offerPartComm;
    private boolean partComm;
    private DHCPServerRangeConfig[] dhcpServerRangeConfigArray;
    private DHCPServerRangeConfig selectedRangeConfig;
    private static final String TRACE_MASKT = "XSETIPPT";
    private static final String TRACE_MASKF = "XSETIPPF";
    private static final String TRACE_MASKD = "XSETIPPD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "IP_P_AddressBean");

    public String[] getPublicPrivateSettingSelection() {
        return this.m_sPublicPrivateSettingSelection;
    }

    public void setPublicPrivateSettingSelection(String[] selected) throws IllegalUserDataException {
        if (selected.length > 0) {
            Trace.trace(TRACE_MASKT, "-> IP_P_AddressBean.setPubPriveSettingSelection: [" + selected[0] + "]");
        } else {
            Trace.trace(TRACE_MASKT, "-> IP_P_AddressBean.setPubPrivSettingSelection ERROR - NO VALUE");
        }
        Trace.trace(TRACE_MASKF, "   IP_P_AddressBean: selection was: " + this.getPublicPrivateSettingSelection()[0] + "; now changed to: " + selected[0]);
        this.m_sPublicPrivateSettingSelection = selected;
        if (selected.length > 0) {
            if (selected[0].endsWith("PUBLICBUTTON")) {
                Trace.trace(TRACE_MASKF, "   SetPubPriv: Do not allow DHCPServer");
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPServerEnabled", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "PartitionComm", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "MANUALBUTTON", true);
                this.setDHCPServerEnabled(false);
            } else {
                Trace.trace(TRACE_MASKF, "   SetPubPriv: Allow DHCPServer");
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPServerEnabled", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "PartitionComm", false);
                this.setPartitionCommunication(false);
                if (!this.isDHCPServerEnabled()) {
                    Trace.trace(TRACE_MASKF, "   CLEAR IPAddr and Mask fields");
                    this.setDHCPClientSelection(new String[]{this.getMountPrefix() + "DHCPBUTTON"});
                }
                this.userTaskManager.setEnabled(this.getMountPrefix() + "MANUALBUTTON", false);
                this.setDHCPServerEnabled(this.isDHCPServerEnabled());
            }
        }
        if (selected.length > 0) {
            Trace.trace(TRACE_MASKT, "<- IP_P_AddressBean.setPubPriveSettingSelection: [" + selected[0] + "]");
        } else {
            Trace.trace(TRACE_MASKT, "<- IP_P_AddressBean.setPubPrivSettingSelection ERROR - NO VALUE");
        }
    }

    public boolean isPartitionCommunication() {
        return this.m_bPartitionCommunication;
    }

    public void setPartitionCommunication(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> IP_P_AddressBean.setPartitionCommunication: " + b);
        this.m_bPartitionCommunication = b;
    }

    public boolean isDHCPServerEnabled() {
        return this.m_bDHCPServerEnabled;
    }

    public void setDHCPServerEnabled(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> IP_P_AddressBean.setDHCPServerEnabled: " + b);
        this.m_bDHCPServerEnabled = b;
        if (b) {
            this.m_cdDHCPServerAddrRange = new ValueDescriptor[this.dhcpServerRangeConfigArray.length];
            for (int i = 0; i < this.dhcpServerRangeConfigArray.length; ++i) {
                String range = this.dhcpServerRangeConfigArray[i].getStart() + " - " + this.dhcpServerRangeConfigArray[i].getEnd();
                this.m_cdDHCPServerAddrRange[i] = new ValueDescriptor(range, range);
                Trace.trace(TRACE_MASKF, "   m_cdDHCPServerAddrRange[" + i + "] = " + range);
            }
            this.userTaskManager.setEnabled(this.getMountPrefix() + "AddressRange", true);
            Trace.trace(TRACE_MASKF, "   setDHCPServer: Enable DHCPServer Address Range");
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPBUTTON", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "ipAddressField", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "maskField", false);
            this.setDHCPServerAddrRange(this.getDHCPServerAddrRange());
        } else {
            if (this.getPublicPrivateSettingSelection()[0].endsWith("PRIVATEBUTTON")) {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "PartitionComm", false);
                this.setPartitionCommunication(false);
                this.setDHCPClientSelection(new String[]{this.getMountPrefix() + "DHCPBUTTON"});
                this.userTaskManager.setEnabled(this.getMountPrefix() + "MANUALBUTTON", false);
            }
            this.userTaskManager.setEnabled(this.getMountPrefix() + "AddressRange", false);
            Trace.trace(TRACE_MASKF, "   setDHCPServer:Disable DHCPServer Address Range");
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPBUTTON", true);
            this.m_cdDHCPServerAddrRange = new ValueDescriptor[0];
            this.m_sDHCPServerAddrRange = "";
            if (this.getDHCPClientSelection()[0].endsWith("MANUALBUTTON")) {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "ipAddressField", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "maskField", true);
            }
            this.refreshMyElements();
        }
        Trace.trace(TRACE_MASKT, "<- IP_P_AddressBean.setDHCPServerEnabled: " + b);
    }

    public String getDHCPServerAddrRange() {
        Trace.trace(TRACE_MASKT, "-> IP_P_AddressBean.getDHCPServerAddrRange: [" + this.m_sDHCPServerAddrRange + "]");
        if (this.m_sDHCPServerAddrRange == "" || this.m_sDHCPServerAddrRange.length() == 0) {
            Trace.trace(TRACE_MASKF, "   m_sDHCPServerAddrRange is null (no selection made)");
            if (this.m_cdDHCPServerAddrRange.length > 0) {
                this.m_sDHCPServerAddrRange = this.m_cdDHCPServerAddrRange[0].getName();
                Trace.trace(TRACE_MASKF, "   Server list exists. Set selection to 1st element");
            } else {
                Trace.trace(TRACE_MASKF, "   List is empty - no selection possible");
            }
        }
        this.userTaskManager.refreshElement(this.getMountPrefix() + "ipAddressField");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "maskField");
        Trace.trace(TRACE_MASKF, "   Extra refresh of IPAddr and Mask: " + this.getIPAddr() + "; " + this.getMask());
        Trace.trace(TRACE_MASKT, "<- IP_P_AddressBean.getDHCPServerAddrRange: [" + this.m_sDHCPServerAddrRange + "]");
        return this.m_sDHCPServerAddrRange;
    }

    public void setDHCPServerAddrRange(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> IP_P_AddressBean.setDHCPServerAddrRange: [" + s + "]");
        this.m_sDHCPServerAddrRange = s;
        boolean done = false;
        if (this.m_cdDHCPServerAddrRange != null) {
            for (int i = 0; i < this.m_cdDHCPServerAddrRange.length && !done; ++i) {
                Trace.trace(TRACE_MASKF, "   m_cdDHCPServerAddrRange[" + i + "].getName() = " + this.m_cdDHCPServerAddrRange[i].getName());
                if (!this.m_sDHCPServerAddrRange.equals(this.m_cdDHCPServerAddrRange[i].getName())) continue;
                String hmcName = this.dhcpServerRangeConfigArray[i].getHmcAddress();
                String mask = this.dhcpServerRangeConfigArray[i].getMask();
                Trace.trace(TRACE_MASKF, "   dhcpServerRangeConfigArray[i].getHmcAddress() = " + this.dhcpServerRangeConfigArray[i].getHmcAddress() + ";  dhcpServerRangeConfigArray[i].getMask() = " + this.dhcpServerRangeConfigArray[i].getMask());
                this.setIPAddr(hmcName);
                this.setMask(mask);
                done = true;
            }
            String[] fixedAddr = new String[]{this.getMountPrefix() + "MANUALBUTTON"};
            this.setDHCPClientSelection(fixedAddr);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "ipAddressField", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "maskField", false);
            this.refreshMyElements();
        }
        Trace.trace(TRACE_MASKT, "<- IP_P_AddressBean.setDHCPServerAddrRange");
    }

    public ValueDescriptor[] getDHCPServerAddrRangeList() {
        Trace.trace(TRACE_MASKT, "<> IP_P_AddressBean.getDHCPServerAddrRangeList");
        return this.m_cdDHCPServerAddrRange;
    }

    public void setDHCPClientSelection(String[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> IP_P_AddressBean.setDHCPClientSelection: " + selected[0]);
        super.setDHCPClientSelection(selected);
        if (selected[0].endsWith("MANUALBUTTON")) {
            if (!this.isDHCPServerEnabled()) {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "ipAddressField", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "maskField", true);
            } else {
                Trace.trace(TRACE_MASKF, "   Keep address/mask fields greyed out");
            }
        }
        this.refreshMyElements();
        Trace.trace(TRACE_MASKT, "<- IP_P_AddressBean.setDHCPClientSelection: " + selected[0]);
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> IP_P_AddressBean.prepare()");
        NetworkInterfaceInformation _netif = this.get_netif();
        boolean configured = this.getConfigured();
        if (_netif.isDhcpClient()) {
            this.setDHCPClientSelection(new String[]{this.getMountPrefix() + "DHCPBUTTON"});
        } else {
            this.setDHCPClientSelection(new String[]{this.getMountPrefix() + "MANUALBUTTON"});
        }
        this.m_sPublicPrivateSettingSelection = _netif.isPrivateIf() ? new String[]{this.getMountPrefix() + "PRIVATEBUTTON"} : new String[]{this.getMountPrefix() + "PUBLICBUTTON"};
        Trace.trace(TRACE_MASKF, "   isDhcpClient() = " + _netif.isDhcpClient() + "; isPrivateIf() = " + _netif.isPrivateIf());
        this.userTaskManager.setShown(this.getMountPrefix() + "PartitionComm", this.offerPartComm);
        String[] publicLan = new String[]{""};
        String[] privateLan = new String[]{""};
        if (this.getNetIfConfig() != null) {
            Trace.trace(TRACE_MASKF, "   Setup initial values according to config file");
            int pubpriv = this.getNetIfConfig().getInterfaceType();
            Trace.trace(TRACE_MASKF, "   -> Pub/Priv InterfaceType = [" + pubpriv + "]");
            switch (pubpriv) {
                case 0: {
                    publicLan = new String[]{this.getMountPrefix() + "PUBLICBUTTON"};
                    this.setPublicPrivateSettingSelection(publicLan);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "PRIVATEBUTTON", false);
                    break;
                }
                case 1: {
                    privateLan = new String[]{this.getMountPrefix() + "PRIVATEBUTTON"};
                    this.setPublicPrivateSettingSelection(privateLan);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "PUBLICBUTTON", false);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "PartitionComm", false);
                    this.setPartitionCommunication(false);
                    this.setDHCPClientSelection(new String[]{this.getMountPrefix() + "DHCPBUTTON"});
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "MANUALBUTTON", false);
                    break;
                }
                default: {
                    if (configured) {
                        Trace.trace(TRACE_MASKF, "   Configured previously; Pub/Priv setting = [" + this.getPublicPrivateSettingSelection()[0] + "]");
                        if (this.getPublicPrivateSettingSelection()[0].endsWith("PUBLICBUTTON")) {
                            publicLan = new String[]{this.getMountPrefix() + "PUBLICBUTTON"};
                            this.setPublicPrivateSettingSelection(publicLan);
                            break;
                        }
                        privateLan = new String[]{this.getMountPrefix() + "PRIVATEBUTTON"};
                        this.setPublicPrivateSettingSelection(privateLan);
                        break;
                    }
                    privateLan = new String[]{this.getMountPrefix() + "PRIVATEBUTTON"};
                    this.setPublicPrivateSettingSelection(privateLan);
                    Trace.trace(TRACE_MASKF, "   Not configured; Default set Private; (PHMC default)");
                }
            }
            Trace.trace(TRACE_MASKF, "   <- Pub/Priv InterfaceType = [" + pubpriv + "]");
            int addrType = this.getNetIfConfig().getAddressType();
            Trace.trace(TRACE_MASKF, "   -> AddressType = [" + addrType + "]");
            switch (addrType) {
                case 0: {
                    this.setDHCPServerEnabled(false);
                    String[] fixedAddr = new String[]{this.getMountPrefix() + "MANUALBUTTON"};
                    this.setDHCPClientSelection(fixedAddr);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPBUTTON", false);
                    break;
                }
                case 1: {
                    this.setDHCPServerEnabled(false);
                    String[] dhcpClntAddr = new String[]{this.getMountPrefix() + "DHCPBUTTON"};
                    this.setDHCPClientSelection(dhcpClntAddr);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "MANUALBUTTON", false);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPSERVERINFOBOX", false);
                    break;
                }
                case 2: {
                    if (!configured && this.m_cdDHCPServerAddrRange.length > 0) {
                        this.m_sDHCPServerAddrRange = this.m_cdDHCPServerAddrRange[0].getName();
                    }
                    this.setDHCPServerEnabled(true);
                    this.setDHCPServerAddrRange(this.getDHCPServerAddrRange());
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPServerEnabled", false);
                    break;
                }
                default: {
                    Trace.trace(TRACE_MASKF, "   CustomerChoice: Use previous static/dhcpC setting: dhcpC = " + _netif.isDhcpClient());
                }
            }
            Trace.trace(TRACE_MASKF, "   <- AddressType = [" + addrType + "]");
            if (this.offerPartComm) {
                if (configured) {
                    Trace.trace(TRACE_MASKF, "   Partition Communication allowed. Use previous setting: " + this.m_bPartitionCommunication);
                } else {
                    this.m_bPartitionCommunication = this.getNetIfConfig().isLparCommunication();
                    Trace.trace(TRACE_MASKF, "   Partition Communication allowed. Use config file setting: " + this.m_bPartitionCommunication);
                }
            } else {
                Trace.trace(TRACE_MASKF, "   Partition Communication not allowed.(see xml file)");
            }
            this.setConfigured(true);
        } else {
            Trace.trace(TRACE_MASKF, "   This lan not found in config file, or we're running RedHat");
        }
        Trace.trace(TRACE_MASKT, "<- IP_P_AddressBean.prepare()");
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        String command = event.getElementName();
        Trace.trace(TRACE_MASKT, "-> IP_P_AddressBean.parentalAction() : " + command);
        PanelTaskletRequest request = new PanelTaskletRequest("ipaddresspanel");
        NetworkInterfaceInformation _netif = this.get_netif();
        if (command.endsWith("detailsOkButton")) {
            Trace.trace(TRACE_MASKF, command.substring(command.lastIndexOf(".") + 1) + " pressed! (IP_P_AddressBean) ");
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            Trace.trace(TRACE_MASKF, " Data Read: getPublicPrivateSettingSelection() = " + this.getPublicPrivateSettingSelection()[0]);
            Trace.trace(TRACE_MASKF, " Data Read: isPartitionCommunication() = " + this.isPartitionCommunication());
            Trace.trace(TRACE_MASKF, " Data Read: isDHCPServerEnabled() = " + this.isDHCPServerEnabled());
            Trace.trace(TRACE_MASKF, " Data Read: getDHCPClientSelection() = " + this.getDHCPClientSelection()[0]);
            Trace.trace(TRACE_MASKF, " Data Read: getIPAddr() = " + this.getIPAddr());
            Trace.trace(TRACE_MASKF, " Data Read: getMask() = " + this.getMask());
            Trace.trace(TRACE_MASKF, " Data Read: getMacAddr() = " + this.getMacAddr());
            Trace.trace(TRACE_MASKF, " Data Read: configured = " + this.getConfigured());
            if (this.getPublicPrivateSettingSelection()[0].endsWith("PRIVATEBUTTON")) {
                _netif.setPrivateIf(true);
            } else {
                _netif.setPrivateIf(false);
            }
            _netif.setMediaSpeed(this.getMediaSpeed());
            _netif.setPartitionCommunication(this.isPartitionCommunication());
            _netif.setDhcpServer(this.isDHCPServerEnabled());
            _netif.setConfigured(this.getConfigured());
            boolean done = false;
            if (this.m_cdDHCPServerAddrRange != null) {
                for (int i = 0; i < this.m_cdDHCPServerAddrRange.length && !done; ++i) {
                    Trace.trace(TRACE_MASKF, "   m_cdDHCPServerAddrRange[" + i + "].getName() = " + this.m_cdDHCPServerAddrRange[i].getName());
                    if (!this.m_sDHCPServerAddrRange.equals(this.m_cdDHCPServerAddrRange[i].getName())) continue;
                    _netif.setDhcpServerRangeConfig(this.dhcpServerRangeConfigArray[i]);
                    Trace.trace(TRACE_MASKF, "   dhcpServerRangeConfigArray[i].getStart() = " + this.dhcpServerRangeConfigArray[i].getStart());
                    done = true;
                }
            }
            try {
                _netif.setIpAddress(InetAddress.getByName(this.getIPAddr()));
                _netif.setNetworkMask(InetAddress.getByName(this.getMask()));
                Trace.trace(TRACE_MASKF, "\n getMask() = " + this.getMask());
                Trace.trace(TRACE_MASKF, "_netif.getNetMask() = " + _netif.getNetMask() + "\n");
            }
            catch (UnknownHostException exc) {
                Trace.trace(TRACE_MASKF, "ILLEGAL DATA ENTERED!   UnknownHostException!!  ");
                HException hexc = new HException(exc);
                new FrameworkLog(_logInfo, 2395, hexc).log();
            }
            String dhcpState = this.getDHCPClientSelection()[0];
            dhcpState = dhcpState.substring(dhcpState.lastIndexOf(".") + 1);
            if (dhcpState.startsWith("DHCP")) {
                _netif.setDhcpClient(true);
            } else {
                _netif.setDhcpClient(false);
            }
            Trace.trace(TRACE_MASKF, "New netif data:  netif.getIpAddress(): " + _netif.getIpAddr());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.getNetworkMask(): " + _netif.getNetMask());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.getAdapterType(): " + _netif.getAdapterType());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.getMacAddress(): " + _netif.getMacAddress());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.isDhcpClient(): " + _netif.isDhcpClient());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.isConfigured(): " + _netif.isConfigured());
            request.setData("panel", "ipaddresspanel");
            request.setData("dataupdates", _netif);
            request.setData("data", this.get_netifIndex());
            this.postTaskletRequest(request);
        } else if (command.endsWith("detailsCancelButton")) {
            Trace.trace(TRACE_MASKF, command.substring(command.lastIndexOf(".") + 1) + " pressed! (IP_P_AddressBean) ");
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            boolean dhcpClientFlag = false;
            String dhcpClientState = this.getDHCPClientSelection()[0];
            dhcpClientState = dhcpClientState.substring(dhcpClientState.lastIndexOf(".") + 1);
            if (dhcpClientState.startsWith("DHCP")) {
                dhcpClientFlag = true;
            }
            if (_netif.isDhcpClient() != dhcpClientFlag || !_netif.getIpAddr().equals(this.getIPAddr()) || !_netif.getNetMask().equals(this.getMask())) {
                ((DetailsFrameBean)parent).setDataChanged();
                Trace.trace(TRACE_MASKF, "   IP_P_AddressBean believes data has changed");
            }
        }
        this.set_netif(_netif);
        Trace.trace(TRACE_MASKF, "<- IP_P_AddressBean.parentalAction()");
    }

    public void storeMyElements() {
        Trace.trace(TRACE_MASKT, "-> IP_P_AddressBean.storeMyElements()");
        this.userTaskManager.storeElement(this.getMountPrefix() + "ipAddressField");
        this.userTaskManager.storeElement(this.getMountPrefix() + "maskField");
        this.userTaskManager.storeElement(this.getMountPrefix() + "macAddr");
        this.userTaskManager.storeElement(this.getMountPrefix() + "PublicPrivateGroup");
        this.userTaskManager.storeElement(this.getMountPrefix() + "PartitionComm");
        this.userTaskManager.storeElement(this.getMountPrefix() + "MediaSpeed");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DHCPClient");
        this.userTaskManager.storeElement(this.getMountPrefix() + "AddressRange");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DHCPServerEnabled");
        Trace.trace(TRACE_MASKF, "   m_sIPAddr " + this.getIPAddr());
        Trace.trace(TRACE_MASKF, "   m_sMask " + this.getMask());
        Trace.trace(TRACE_MASKF, "   m_sMacAddr " + this.getMacAddr());
        Trace.trace(TRACE_MASKF, "   m_sPublicPrivateSettingSelection " + this.m_sPublicPrivateSettingSelection[0]);
        Trace.trace(TRACE_MASKF, "   m_bPartitionCommunication " + this.m_bPartitionCommunication);
        Trace.trace(TRACE_MASKF, "   m_sMediaSpeed " + this.getMediaSpeed());
        Trace.trace(TRACE_MASKF, "   m_sDHCPClientSelection " + this.getDHCPClientSelection()[0]);
        Trace.trace(TRACE_MASKF, "   m_sDHCPServerAddrRange " + this.m_sDHCPServerAddrRange);
        Trace.trace(TRACE_MASKF, "   m_bDHCPServerEnabled " + this.m_bDHCPServerEnabled);
        Trace.trace(TRACE_MASKT, "<- IP_P_AddressBean.storeMyElements()");
    }

    public void refreshMyElements() {
        Trace.trace(TRACE_MASKT, "-> IP_P_AddressBean.refreshMyElements()");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "ipAddressField");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "maskField");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "macAddr");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "PublicPrivateGroup");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "PartitionComm");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "MediaSpeed");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DHCPClient");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "AddressRange");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DHCPServerEnabled");
        Trace.trace(TRACE_MASKT, "<- IP_P_AddressBean.refreshMyElements()");
    }

    public void setNetworkInterface(NetworkInterfaceInformation netif, Integer netifIndex, NetworkSettingsConfig networkSettingsConfig) {
        Trace.trace(TRACE_MASKT, "-> IP_P_AddressBean.setNetworkInterface()");
        super.setNetworkInterface(netif, netifIndex, networkSettingsConfig);
        if (netif.isDhcpServer()) {
            this.m_bDHCPServerEnabled = true;
            this.selectedRangeConfig = netif.getDhcpServerRangeConfig();
            String range = this.selectedRangeConfig.getStart() + " - " + this.selectedRangeConfig.getEnd();
            Trace.trace(TRACE_MASKF, "   IS a DHCP Server; Range: " + range);
            this.m_sDHCPServerAddrRange = range;
        } else {
            this.m_bDHCPServerEnabled = false;
        }
        this.m_bPartitionCommunication = netif.isPartitionCommunication();
        Trace.trace(TRACE_MASKF, "   m_sIPAddr " + this.getIPAddr());
        Trace.trace(TRACE_MASKF, "   m_sMask " + this.getMask());
        Trace.trace(TRACE_MASKF, "   m_sMacAddr " + this.getMacAddr());
        Trace.trace(TRACE_MASKF, "   m_bDHCPServerEnabled " + this.m_bDHCPServerEnabled);
        Trace.trace(TRACE_MASKF, "   m_sDHCPServerAddrRange " + this.m_sDHCPServerAddrRange);
        Trace.trace(TRACE_MASKF, "   Configured =" + this.getConfigured());
        Trace.trace(TRACE_MASKF, "   m_sMediaSpeed " + this.getMediaSpeed());
        Trace.trace(TRACE_MASKF, "   PartitionCommunication =" + this.m_bPartitionCommunication);
        if (this.getNetSetConfig() != null) {
            this.offerPartComm = this.getNetSetConfig().isOfferLPARCheckbox();
            this.dhcpServerRangeConfigArray = this.getNetSetConfig().getDHCPServerRangesArray();
            if (netif.isDhcpServer()) {
                this.m_sDHCPServerAddrRange = netif.getDhcpServerRangeConfig().getStart() + " - " + netif.getDhcpServerRangeConfig().getEnd();
                Trace.trace(TRACE_MASKF, " m_sDHCPServerAddrRange = [" + this.m_sDHCPServerAddrRange + "]");
            }
        }
        Trace.trace(TRACE_MASKT, "<- IP_P_AddressBean.setNetworkInterface()");
    }
}

